
#ifndef __I2C_H__
#define __I2C_H__

///////////////////////////////////////////////////////////////////////////////

#include "dm_i2c.h"


#ifdef __cplusplus
extern "C" {
#endif

#define I2C_BUS_BIT                     4
#define I2C_MUX_BIT                     4
#define GET_I2C_BUS(a)                 (a & 0x0F)
#define GET_I2C_MUX(a)                 ((a>>I2C_MUX_BIT) & 0x0F)
#define ADD_MUX_TO_BUS(mux,bus)        ( ((mux << I2C_MUX_BIT)& 0xF0) | (bus & 0x0F) )
typedef UINT32 I2C_MuxSelection(UINT8);

typedef BOOL (*PF_I2C_RECOVER_ERROR) ( UINT8 bInstance );

#ifdef STR91X_IAR
#define MAX_I2C_BUSES                   2

typedef struct _I2CHELPER
{
    I2CADDR addr;
    I2CADDR DataAddr;
    UINT8*  pData;
    UINT16  idx;
    UINT16  event;
    UINT16  byteCnt;
    BOOL    complete;   //rwc: caused hard fault as 1-byte bool
    BOOL    SegAddr;    //same
    UINT8   step;
    UINT32  lock;
    UINT32  unexpectedEventCnt;
    UINT32  speed;
    UINT32  isrCnt;
	UINT32  oldInst;
	I2C_MuxSelection * selectMux;
    PF_I2C_RECOVER_ERROR pRecoverError;
} I2CHELPER;

#endif // STR91X_IAR

#ifdef IAR_ARM_CM3
#ifdef STM32F2XX
#define MAX_I2C_BUSES                   3 // 3 I2C for stm32f2
#else
#define MAX_I2C_BUSES                   2
#endif // STM32F2XX
#define MAX_I2C_SLAVE_BUSES             1

typedef struct _I2CHELPER
{
    I2CADDR addr;
    I2CADDR DataAddr;
    UINT8*  pData;
    UINT32  idx;
    UINT32  byteCnt;
    UINT32  event;
    UINT32  debugLevel;                      // nu
    BOOL    complete;
    BOOL    doingWrite; //same              // nu
    BOOL    noSubAddr;  //same              // nu
    BOOL    SegAddr;    //same
    UINT16  step;
    UINT32  lock;
    UINT32  isrCnt;
    UINT32  unexpectedEventCnt;
    UINT32  RecoverCnt;                      // nu
    UINT32  oldInst;
    UINT32  speed;
    I2C_MuxSelection * selectMux;
    PF_I2C_RECOVER_ERROR pRecoverError;     // nu
} I2CHELPER;

/*
typedef struct _I2C_SLAVE_HELPER
{
    UINT8 readIndex;
    UINT8 writeIndex;
    UINT8 writeByteCnt;
    UINT8 i2CStateMachineState;
    UINT32 unexpectedEventCnt;
    UINT32 unexpectedStateCount;
    UINT8 slaveReceiveBuffer[258];
    UINT8 slaveSendBuffer[258];
} I2C_SLAVE_HELPER;
*/

//extern I2C_SLAVE_HELPER I2CSlaveHelper[MAX_I2C_SLAVE_BUSES];

#endif // IAR_ARM_CM3

extern I2CHELPER I2CHelper[MAX_I2C_BUSES];


///////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif  //__I2C_H__
